﻿//////////////////////////////////////////////
// TestRunParameters.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestObserver ;

	struct TestNameFilters ;
}

/// Includes ---------------------------------

// nkDebug
#include "../Dll/DllDefines.h"

// nkLog
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestRunParameters final
	{
		public  :

			// Functions
			// Constructor, destructor
			TestRunParameters () noexcept ;
			TestRunParameters (const TestRunParameters& other) noexcept ;
			TestRunParameters (TestRunParameters&& other) noexcept ;
			~TestRunParameters () ;

			// Getters
			nkMemory::StringView getClassNameFilter () const ;
			nkMemory::StringView getFunctionNameFilter () const ;
			TestObserver* getObserver () const ;

			// Setters
			void setClassNameFilter (nkMemory::StringView value) ;
			void setFunctionNameFilter (nkMemory::StringView value) ;
			void setObserver (TestObserver* value)  ;

			// Operators
			TestRunParameters& operator= (const TestRunParameters& other) noexcept ;
			TestRunParameters& operator= (TestRunParameters&& other) noexcept ;

		private :

			// Attributes
			TestNameFilters* _filters ;
			TestObserver* _observer ;
	} ;
}